/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import vectorwing.farmersdelight.utils.TextUtils;

public class FeastBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final IntegerProperty SERVINGS = IntegerProperty.func_177719_a((String)"servings", (int)0, (int)4);
    public final Supplier<Item> servingItem;
    public final boolean hasLeftovers;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)};

    public FeastBlock(AbstractBlock.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers) {
        super(properties);
        this.servingItem = servingItem;
        this.hasLeftovers = hasLeftovers;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(4)));
    }

    public ItemStack getServingItem() {
        return new ItemStack((IItemProvider)this.servingItem.get());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)SERVINGS)];
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K && this.takeServing((IWorld)worldIn, pos, state, player, handIn).func_226246_a_()) {
            return ActionResultType.SUCCESS;
        }
        return this.takeServing((IWorld)worldIn, pos, state, player, handIn);
    }

    private ActionResultType takeServing(IWorld worldIn, BlockPos pos, BlockState state, PlayerEntity player, Hand handIn) {
        int servings = (Integer)state.func_177229_b((Property)SERVINGS);
        if (servings == 0) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187881_gQ, SoundCategory.PLAYERS, 0.8f, 0.8f);
            worldIn.func_175655_b(pos, true);
            return ActionResultType.SUCCESS;
        }
        ItemStack serving = this.getServingItem();
        ItemStack heldItem = player.func_184586_b(handIn);
        if (servings > 0) {
            if (heldItem.func_77969_a(serving.getContainerItem())) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                if (!player.field_71071_by.func_70441_a(serving)) {
                    player.func_71019_a(serving, false);
                }
                if ((Integer)worldIn.func_180495_p(pos).func_177229_b((Property)SERVINGS) == 0 && !this.hasLeftovers) {
                    worldIn.func_217377_a(pos, false);
                }
                worldIn.func_184133_a(null, pos, SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b((ITextComponent)TextUtils.getTranslation("block.feast.use_container", serving.getContainerItem().func_200301_q()), true);
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SERVINGS});
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((Property)SERVINGS);
    }

    public int getMaxServings() {
        return 4;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

